function [PCs, Scores_TrialSubj, EV_eigenvalues, varargout] = pca_PMAnalyzer(varargin)
% Input is either: - A cell containing matrices
%                  - More than two matrices to perform pca with
%
% Siehe Beispiel in http://arxiv.org/pdf/1404.1100.pdf Die Matrix X muss
% hier als "data" bergeben werden, aber im Vergleich zum Paper transponiert (X')!
% Das bedeutet: Die Variablen (Verschiedenen Kameras) sind im Link als Zeilen,
% hier in "pca_tommy(...)" als Spalten anzuordnen.
%
% Output (hnlich wie im Paper):
%       - Eigenwerte "eigenvalues" in einem Zeilenvektor
%       - Eigenvektoren (= Principal components "PCs").
%       - Signals
%
% Die resultierenden Signals (scores) werden im Paper nach Signal_i = (PCi)' * X berechnet.
% Dank (A*B)' = B'*A' bekommen wir mit diesem Code Signal_i_tommy = X' * PCi
% (X' hatte die Variablen Spaltenweise angeordnet! Man braucht also Signale in Form
% von Spalten (bereinstimmend mit der Lnge der Zeilen von X')
%
% Comment: This function works as the matlab function "pca(...)" with the
% option to let out the centering and the option to normalize data in any
% way the function "normalization_options" is changed.
%
% Typical input:  [PCs, scores, EV,mean_matrix, norm, weights_inverse] = pca_tommy(Data_all, sex_string);
% ATTENTION: The weight_options function must be checked to be used! Most of
% all if markers are cut out!

Data_all            = varargin{1};

trials_readin       = varargin{2};
subjects_readin     = varargin{3};

norm_assignment     = varargin{4}{1};
weights_assignment  = varargin{4}{2};
gender_matrix       = varargin{4}{3};
size_matrix         = varargin{4}{4};
trial_left_out      = varargin{4}{5};
subj_left_out       = varargin{4}{6};


max_trials   = max(trials_readin);
max_subj     = max(subjects_readin);


dataAll =[];
mean_matrices = cell(max_trials, max_subj);
norm_matrix = [max_trials, max_subj];
weights_inverses = cell(max_trials, max_subj);
ctr_TrialSubj = 0;


CentNormWeigh_order = 1; % Default: Normalize to height: needs original data for height -> then center -> then weight
if sum(norm_assignment == [2]) % MED: first center-> weight -> then MED!
    CentNormWeigh_order = 1;
elseif sum(norm_assignment == [5,6,7]) % Max Range: Center -> Compute Max Range of markers -> Weight
    CentNormWeigh_order = 1;
elseif sum(norm_assignment == [3,4]) % Max Range: Center -> Compute Max Range of markers -> Weight
    CentNormWeigh_order = 3;
elseif sum(norm_assignment == [8]) % Max Range: Center -> Compute Max Range of markers -> Weight
    CentNormWeigh_order = 2;

end


if CentNormWeigh_order == 1 % Center, then weight, then normalize
    CNW_fun3 = @optionsNormalization;   assignment3 = norm_assignment;      descr3 = 'Normalized: ';
    CNW_fun1 = @center_data;            assignment1 = 0;                    descr1 = 'Centered: Each marker coordinate centered separately';
    CNW_fun2 = @optionsWeights;         assignment2 = weights_assignment;   descr2 = 'Weighted: ';
elseif CentNormWeigh_order == 2 % Center, then normalize, then weight
    CNW_fun2 = @optionsNormalization;   assignment2 = norm_assignment;      descr2 = 'Normalized: ';
    CNW_fun1 = @center_data;            assignment1 = 0;                    descr1 = 'Centered: Each marker coordinate centered separately';
    CNW_fun3 = @optionsWeights;         assignment3 = weights_assignment;   descr3 = 'Weighted: ';
elseif CentNormWeigh_order == 3 % Normalize, then center, then weight
    CNW_fun1 = @optionsNormalization;   assignment1 = norm_assignment;      descr1 = 'Normalized: ';
    CNW_fun2 = @center_data;            assignment2 = 0;                    descr2 = 'Centered: Each marker coordinate centered separately';
    CNW_fun3 = @optionsWeights;         assignment3 = weights_assignment;   descr3 = 'Weighted: ';
elseif CentNormWeigh_order == 4 % Normalize, then weight, then center
    CNW_fun1 = @optionsNormalization;   assignment1 = norm_assignment;      descr1 = 'Normalized: ';
    CNW_fun3 = @center_data;            assignment3 = 0;                    descr3 = 'Centered: Each marker coordinate centered separately';
    CNW_fun2 = @optionsWeights;         assignment2 = weights_assignment;   descr2 = 'Weighted: ';
elseif CentNormWeigh_order == 5 % Weight, then center, then normalize
    CNW_fun3 = @optionsNormalization;   assignment3 = norm_assignment;      descr3 = 'Normalized: ';
    CNW_fun2 = @center_data;            assignment2 = 0;                    descr2 = 'Centered: Each marker coordinate centered separately';
    CNW_fun1 = @optionsWeights;         assignment1 = weights_assignment;   descr1 = 'Weighted: ';
elseif CentNormWeigh_order == 6 % Weight, then normalize, then center
    CNW_fun2 = @optionsNormalization;   assignment2 = norm_assignment;      descr2 = 'Normalized: ';
    CNW_fun3 = @center_data;            assignment3 = 0;                    descr3 = 'Centered: Each marker coordinate centered separately';
    CNW_fun1 = @optionsWeights;         assignment1 = weights_assignment;   descr1 = 'Weighted: ';
end    

%% Norm and center
center_norm_weigh = 1; % Disable if no "normalization", "centering" or "weighing" wanted
for TrialNow = trials_readin
    for SubjNow = subjects_readin
        if TrialNow ~= trial_left_out || SubjNow ~= subj_left_out
            dataNow = Data_all{TrialNow, SubjNow};
            if center_norm_weigh
                % Compute and save the means of all data!
                mean_of_Data = mean(dataNow,1); % mean of each column
                mean_of_Data = repmat(mean_of_Data, size(dataNow,1),1);%size(data1,1)
                mean_matrices{TrialNow, SubjNow} = mean_of_Data;
                % Assigns TrialSubj specification and gender
                ctr_TrialSubj = ctr_TrialSubj + 1;
                genderNow = gender_matrix(TrialNow, SubjNow);
                
                % Center, norm or weighting step 1
                fprintf(['      Data of trial %d, subject %d is \n            ', descr1], TrialNow, SubjNow)
                [data_CNW1,CNW_output1, ~] = CNW_fun1(dataNow, assignment1, genderNow, ctr_TrialSubj);
                % Center, norm or weighting step 3
                fprintf(['\n            ', descr2])
                [data_CNW2, CNW_output2, ~] = CNW_fun2(data_CNW1, assignment2, genderNow, ctr_TrialSubj);
                % Center, norm or weighting step 3
                fprintf(['\n            ', descr3])
                [data_CNW3, CNW_output3, ~] = CNW_fun3(data_CNW2, assignment3, genderNow, ctr_TrialSubj);% 'f', 'm' or '0' (else no weight are assigned)
                fprintf('\n\n')
                
                % Concatenates processed data
                dataAll =[dataAll;data_CNW3];
                
                %Saves "weights_inverse" and "norm" for later reverse computation
                if CentNormWeigh_order == 1
                    d_norm      = CNW_output3;
                    weights_inv = CNW_output2;
                elseif CentNormWeigh_order == 2
                    d_norm      = CNW_output2;
                    weights_inv = CNW_output3;
                elseif CentNormWeigh_order == 3
                    d_norm      = CNW_output1;
                    weights_inv = CNW_output3;
                elseif CentNormWeigh_order == 4
                    d_norm      = CNW_output1;
                    weights_inv = CNW_output2;
                elseif CentNormWeigh_order == 5
                    d_norm      = CNW_output3;
                    weights_inv = CNW_output1;
                elseif CentNormWeigh_order == 6
                    d_norm      = CNW_output2;
                    weights_inv = CNW_output1;
                end
                
                norm_matrix(TrialNow, SubjNow) = d_norm;
                weights_inverses{TrialNow, SubjNow} = weights_inv;
            else
                dataAll = [dataAll;dataNow];
                fprintf('    \n\nNormalization, centering and weighing disabled!\n\n')
            end
        end
    end
end



if weights_assignment == 2
    delete('tmpManuallyChosenWeightVector.mat')
end


%% ***************  Start: Code for PCA via SVD (Y = 1/sqrt X^T)**************
dataPCA = dataAll;
Y = dataPCA/sqrt(size(dataPCA,1)-1);
% [U,S,V] = svd(Y) => Y = U*S*V'
[~,S,PCs] = svd(Y,'econ');

%Calculate variances
EV_eigenvalues = (diag(S).^2)';
allScores = dataAll*PCs;  % The "signals" in the paper

sm = size_matrix';
Scores_TrialSubj = cell(max_trials,max_subj);
for trial = setdiff(trials_readin,trial_left_out)
    for subj = setdiff(subjects_readin,subj_left_out)
        tsNow = (trial-1)*max_subj+subj;
        % This "if statement" is only used for the leave-one-out-cross-validation!
        if trial_left_out ~= 0 && subj_left_out ~= 0
            sm(subj_left_out, trial_left_out) = 0;
        end
        Scores_TrialSubj{trial,subj} = allScores(sum(sm(1:tsNow))-sm(tsNow)+1:sum(sm(1:tsNow)),:);
    end
end



% INFOS:
% ------
% "Pcs" are also called "loadings" or as in "pca(...)"
% coefficients and can be interpreted as the new
% coordinatesystem (ONB = OrthoNormalBasis)

% Output
varargout{1} = mean_matrices;
varargout{2} = norm_matrix;
varargout{3} = weights_inverses;

% ***************  End: Code for PCA via SVD (Y = 1/sqrt X^T)**************






%%       ***************   Used centering function   ***************

    function [ data_centered, mean_matrix1, emptyOutput ] = center_data( varargin )
        dataToCenter = varargin{1};
        mean_dataToCenter = mean(dataToCenter,1); % mean of each column
        mean_matrix1 = repmat(mean_dataToCenter, size(dataToCenter,1),1);%size(data1,1)
        data_centered = dataToCenter-mean_matrix1;
        emptyOutput = 'Empty';
%         fprintf('\n           Data was centered!')
    end % end function "center_data"







end

